#!/usr/bin/env python
import requests
import json
import time, datetime
from datetime import date
import sys
import base64
import os, re, os.path
import xbmc
import glob
import xbmcvfs
from urllib.request import urlopen
from urllib.parse import urlparse
from pathlib import Path

VERSION = "1.0"

#xbmc.executebuiltin('CECToggleState')
screenshotpath = xbmcvfs.translatePath('special://screenshots') 

lockfile = Path(screenshotpath+"lockdonwload.txt")
if lockfile.is_file():
  filestamp = os.stat(screenshotpath+"lockdonwload.txt").st_mtime
  now = time.time()
  critical_time = now -  3600 
  if filestamp < critical_time:
    try:
      os.remove(screenshotpath+"lockdonwload.txt")
    except OSError:
      pass

if lockfile.is_file():     
  exit(0)


def download_file(url,folder,name):
    local_filename = folder+name
    try:
      with requests.get(url, stream=True) as r:
          r.raise_for_status()
          with open(local_filename, 'wb') as f:
              for chunk in r.iter_content(chunk_size=8192): 
                  # If you have chunk encoded response uncomment if
                  # and set chunk_size parameter to None.
                  #if chunk: 
                  f.write(chunk)
    except requests.exceptions.RequestException as e:
      try:
        os.remove(screenshotpath+"lockdonwload.txt")
      except OSError:
        exit(0)
    return local_filename


kodi_credentials = b'kodi:1234' 
kodi_encoded_credentials = base64.b64encode(kodi_credentials) 
kodi_authorization = b'Basic ' + kodi_encoded_credentials 
kodi_header = { 'Content-Type': 'application/json', 'Authorization': kodi_authorization } 
kodi_ip = '127.0.0.1'
kodi_port = '8080'
kodi_url = 'http://' + kodi_ip + ':' + kodi_port + '/jsonrpc'

# verifica se cè una playlist in esecuzione
kodi_players='{"jsonrpc": "2.0", "method": "Player.GetActivePlayers", "id": 1}'
kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_players)
isActive=0
try:
  json_data = kodi_response.json()
  for k in json_data['result']:
    isActive=1
except:
  print('Errore : nessun player attivo')
  print(kodi_response)



# cerca il path degli screenshot

    
screenshotfile=screenshotpath+'screenshotfiletemp.png'

# invia screenshot al server
xbmc.executebuiltin('TakeScreenshot('+screenshotfile+')')
time.sleep(5)
url = 'https://arkiweb2.homeip.net/api/v3/kodi/monitorcheck'
files = {'media': open(screenshotfile, 'rb')}
values={'monitor_id':'lv1'}
response   = requests.post(url, files=files,data=values)
json_data = json.dumps(response.json(), indent=4, sort_keys=True)



#xbmc.executebuiltin('XBMC.CECActivateSource')
#time.sleep(10)
#xbmc.executebuiltin('XBMC.CECToggleState')
#time.sleep(10)
#xbmc.executebuiltin('XBMC.CECStandby')
#time.sleep(10)


#kodi_params = json.dumps({"jsonrpc":"2.0","id":"1","method":"Player.Open","params":{"item":{"file":"http://netvideo.koolsuite.it/temp/video24-10-14_19-27-05-85.mkv"}}})
#kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_params)

#kodi_params = json.dumps({"jsonrpc":"2.0","id":0,"method":"Player.Open","params":{"item":{ "file" : "plugin://plugin.video.youtube/play/?video_id=dmYdU_9pfA4" }}})

#kodi_params = json.dumps([{"jsonrpc": "2.0", "id": 0, "method": "Playlist.Clear", "params": {"playlistid": 0}},
#{"jsonrpc":"2.0","id":0,"method":"Playlist.Add","params":{"playlistid":0,"item":{"file":"http://netvideo.koolsuite.it/temp/video24-10-14_19-27-05-85.mkv"}}},
#{"jsonrpc":"2.0","id":0,"method":"Playlist.Add","params":{"playlistid":0,"item":{"file":"plugin://plugin.video.youtube/play/?video_id=dmYdU_9pfA4"}}},
#{"jsonrpc":"2.0","id":0,"method":"Player.Open","params":{"item":{"playlistid":0,"position":0}}}])

#kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_params)
#print(kodi_response)



try: 
  response = requests.post('https://arkiweb2.homeip.net/api/v3/kodi/monitorcheck', data={	"isActive":isActive,"monitor_id":"lv1","script_version":VERSION},timeout = 5, verify = True)
  response.raise_for_status() 
except requests.exceptions.HTTPError as errh: 
  print('HTTPError')
  exit(0)
except requests.exceptions.ReadTimeout as errrt: 
  print('ReadTimeout')
  exit(0)
except requests.exceptions.ConnectionError as conerr: 
  print('ConnectionError')
  exit(0)

json_data = json.dumps(response.json(), indent=4, sort_keys=True)
json_object  = json.loads(json_data)

x = ('arkiweb2', 'homeip', 'net')
kodi_params = ''

for k in json_object['Result']['movies']:
  y = id(x)
  a = urlparse(str(k))
  file_name, file_extension = os.path.splitext(str(k))
  file_name=screenshotpath+os.path.basename(a.path)
  file_name=file_name.replace("\\", "/")
  
  # se la playlist e cambaiata cancello tutti i files
  filevideo = Path(file_name)
  if not filevideo.is_file():
    # pulisce directory screenshot 
    files = glob.glob(screenshotpath+'*.*', recursive=False)
    for filename in files:
      try:
        os.remove(filename)
      except OSError:
        pass

with open(screenshotpath+"lockdonwload.txt", "w") as f:
  f.write("locked")

for k in json_object['Result']['movies']:
  y = id(x)
  a = urlparse(str(k))
  file_name, file_extension = os.path.splitext(str(k))
  file_name=screenshotpath+os.path.basename(a.path)
  file_name=file_name.replace("\\", "/")
  # non scarica se presente 
  filevideo = Path(file_name)
  if not filevideo.is_file():
    fname=download_file(str(k),screenshotpath,os.path.basename(a.path))  

  if kodi_params == '':
    kodi_params = ('{"jsonrpc":"2.0","id":0,"method":"Playlist.Add","params":{"playlistid":0,"item":{"file":"' + file_name + '"}}}')
  else:
    kodi_params = kodi_params + ","+ "\n" + ('{"jsonrpc":"2.0","id":0,"method":"Playlist.Add","params":{"playlistid":0,"item":{"file":"' + file_name + '"}}}')

try:
  os.remove(screenshotpath+"lockdonwload.txt")
except OSError:
  pass 

if kodi_params != '':
  kodi_params = '[' + kodi_params + ',{"jsonrpc":"2.0","id":0,"method":"Player.Open","params":{"item":{"playlistid":0,"position":0},"options":{"repeat":"all"}}}]'


if kodi_params != '':
  kodi_players='{"jsonrpc": "2.0", "method": "Playlist.Clear", "params": { "playlistid": 0 }, "id": 1}'
  kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_players)

  kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_params)

# mette in pausa commands 
if 'commands' in json_object['Result']:
  if json_object['Result']['commands'] == 'Sleep':
    kodi_players='{"jsonrpc": "2.0", "method": "Playlist.Clear", "params": { "playlistid": 0 }, "id": 1}'
    kodi_response = requests.post(kodi_url, headers=kodi_header, data=kodi_players)
    xbmc.executebuiltin('ActivateScreensaver')

# Update addon
  if json_object['Result']['commands'] == 'UpdateAddon':
    local = xbmcvfs.translatePath('special://home/addons') 
    data = urlopen(target_url).read()
    with open(local+"lv1/default.py", "wb") as f:
      f.write(data)



time.sleep(5)

#xbmc.executebuiltin('Reboot')
#xbmc.executebuiltin('CECToggleState')


# cancella screenshot se esiste
time.sleep(5)
if screenshotfile != '':
  try:
    os.remove(screenshotfile)
  except OSError:
    pass
  
  
#xbmc.executebuiltin('XBMC.CECStandby')


   
   